﻿  package{
	  import flash.display.*;
	  import flash.text.*;
	  import flash.events.*;
	  import flash.net.*;
	  import flash.geom.Rectangle;
	  import flash.ui.ContextMenu;
	  import flash.ui.ContextMenuItem;
	  import Website;
	  
	  public class ItemHolder extends Sprite{		  
	  	  public var dispatcher:EventDispatcher = new EventDispatcher();
		  public var mc_data:Loader = new Loader();
		  public var itemName:String = "";
		  public var itemType:String = "";
		  public var itemFilename:String = "";
		  public var itemDesc:String = "";
		  public var itemOrder:Number = 0;
		  public var itemID:Number = 0;
		  public var itemLink:String = "";
		  public var serialNumber:Number = 0;
		  public var bitmapImage:Bitmap;
		  public var flagSelected:Boolean = false;
		  
		  //state of the holder: init,loaded,error
		  public var holderState = "init";
		  
		  //item data coordinates
		  public var dataWidth:Number;
		  public var dataHeight:Number;
		  public var datax:Number;
		  public var datay:Number;
		  
		  //item mode	(normail, editName)
		  public var mode:String = "normal";
		  public var flagStageEvent:Boolean = false;		  
		  
		  public var flagInputClick:Boolean = false;	//catch input box click
		  
		  public var contextItemDeleteSelected:ContextMenuItem;
		  public var contextItemMenuID:ContextMenuItem;
		  
		  public var flagContextClick = false;	//flag on click context item (for mouseoverborder)
		  		  
		  
		  //inline items:
		  //txtName
		  //mc_frame
		  //mc_back
		  //mc_back_selected
		  //mc_loadError
		  //input_name
		  //mc_mouseOverBorder
		  
		  //constructor
		  public function ItemHolder(){
				setContextMenu();
				
				//hode the selected border
				mc_mouseOverBorder.visible = false;
				
				//format the input box
				var format:TextFormat = new TextFormat;
				format.align = TextFormatAlign.CENTER;
				this.input_name.setStyle("textFormat",format);
				//hide input box
				this.input_name.visible = false;
				
			  	mc_loadError.visible = false;
				this.dataWidth = Math.floor(mc_frame.width-2);
				this.dataHeight = Math.floor(mc_frame.height-2);				
				this.datax = Math.floor(mc_frame.x+1);
				this.datay = Math.floor(mc_frame.y+1);
				
				// set loaded events:
				mc_data.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, loadProgress);
				mc_data.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComplete);
				mc_data.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, loadIOError, false, 0, true);
				mc_data.contentLoaderInfo.addEventListener(SecurityErrorEvent.SECURITY_ERROR, loadSecurityError, false, 0, true);
				
				//set input events:
				this.input_name.addEventListener(KeyboardEvent.KEY_DOWN,onInputNameKeyDown);
				this.input_name.addEventListener(MouseEvent.MOUSE_DOWN,onInputNameMouseDown);
				
				//set movieclip events
				this.addEventListener(MouseEvent.MOUSE_OVER,onMouseOver);
				this.addEventListener(MouseEvent.MOUSE_OUT,onMouseOut);
				
				setNormal();
		  }
			
			//--------------------------------------------------------
			// set context menu for website object
			public function setContextMenu(){
				var menu:ContextMenu = new ContextMenu();
				
				//add menu event:
				menu.addEventListener(ContextMenuEvent.MENU_SELECT,onContextMenuApear);
				menu.hideBuiltInItems();
				
				//Edit name
				var	itemEditName:ContextMenuItem = new ContextMenuItem("Edit title");
				itemEditName.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT,onEditNameClick);
				menu.customItems.push(itemEditName);

				//Edit desc
				var	itemEditDesc:ContextMenuItem = new ContextMenuItem("Edit item");
				itemEditDesc.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT,onEditDescriptionClick);
				menu.customItems.push(itemEditDesc);
				
				//delete item
				var	itemDelete:ContextMenuItem = new ContextMenuItem("Delete item");
				itemDelete.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT,onDeleteClick);
				menu.customItems.push(itemDelete);

				//delete selected ietms
				var	itemDeleteSelected:ContextMenuItem = new ContextMenuItem("Delete selected items");
				itemDeleteSelected.enabled = false;
				itemDeleteSelected.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT,onDeleteSelectedClick);
				menu.customItems.push(itemDeleteSelected);
				this.contextItemDeleteSelected = itemDeleteSelected;
				
				//preview item
				var	itemPreview:ContextMenuItem = new ContextMenuItem("Preview item",true);
				itemPreview.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT,onPreviewClick);
				menu.customItems.push(itemPreview);
				
				//download item
				var	itemDownload:ContextMenuItem = new ContextMenuItem("Download item");
				itemDownload.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT,onDownloadItemClick);
				menu.customItems.push(itemDownload);
				
				//add context menu item: id
				var item_itemID:ContextMenuItem = new ContextMenuItem("Item ID:",true);
				item_itemID.visible = false;
				menu.customItems.push(item_itemID);
				this.contextItemMenuID = item_itemID;
				
				this.contextMenu = menu;
			}
		  
		  
	      //-------------------------------------------------------------------------
		  // event when appears context menu.
		  public function onContextMenuApear(event:ContextMenuEvent){
			  this.flagContextClick = true;
			  var moviesHolder = this.parent;
			  var numSelected = moviesHolder.getNumSelectedHolders();
			  if(numSelected > 0) this.contextItemDeleteSelected.enabled = true;
			  else this.contextItemDeleteSelected.enabled = false;				  
		  }
		  
	      //-------------------------------------------------------------------------
		  // show mouse over border
		  public function showMouseOverBorder(){
			  var moviesHolder = this.parent;
			  moviesHolder.hideOverBorderFromLastHolder();	//if some over border on other item exists - hide it.
			  this.mc_mouseOverBorder.visible = true;
			  moviesHolder.lastOverHolder = this;
		  }
		  
	      //-------------------------------------------------------------------------
		  // hide mouse over border
		  public function hideMouseOverBorder(){
			  this.mc_mouseOverBorder.visible = false;
			  var moviesHolder = this.parent;
			  if(moviesHolder == null) return(false);	//happends when reseting items
			  moviesHolder.lastOverHolder = null;
		  }
		  
	      //-------------------------------------------------------------------------
		  // on mouse over event. show mouse over border
		  public function onMouseOver(event:MouseEvent){
			  showMouseOverBorder();
		  }
		  
	      //-------------------------------------------------------------------------
		  // on mouse out event. hide mouse over border
		  public function onMouseOut(event:MouseEvent){
			  if(this.flagContextClick == true){	//if context menu clicked - don't hide border
				  this.flagContextClick = false;
				  return(false);
			  }
			  hideMouseOverBorder();
		  }

		  
	      //-------------------------------------------------------------------------
		  // stage mouse down event. stop the edit mode. (if not clicked on input box before.
		  private function onStageMouseDown(event:MouseEvent){
			  if(this.flagInputClick == true){
				  this.flagInputClick = false;
				  return(false);
			  }
			  if(this.mode != "editName") return(false);
			  			  
			  endEditMode(true);
		  }
		  
	      //-------------------------------------------------------------------------
		  // input box click. remember the click for stage click event.
		  private function onInputNameMouseDown(event:MouseEvent){
			  this.flagInputClick = true;
		  }
		  
	      //-------------------------------------------------------------------------
		  // input box key down. exit edit mode, and save name
		  public function onInputNameKeyDown(event:KeyboardEvent){
			  switch(event.keyCode){
				  case 13:	//enter - close edit mode with saving
				  	endEditMode(true);
				  break;
				  case 27:	//escape - close edit mode without saving.
				  	endEditMode(false);
				  break;
			  }
		  }
		  
		  
	      //-------------------------------------------------------------------------
		  //switch edit item mode.
		  public function changeToEditMode(preventStageEvent:Boolean){
			  if(preventStageEvent == true) this.flagInputClick = true; //prevent stage event to take place.
			  
			  //disable all items besides txtName
			  this.mouseChildren = true;			  
			  var child;
			  for(var i=0;i<this.numChildren;i++){
				child = this.getChildAt(i);
				if(child.name != "txtName") child.mouseEnabled = false;
			  }
			  
			  //set stage mouse down event
			  if(stage !== null && this.flagStageEvent == false){
				  stage.addEventListener(MouseEvent.MOUSE_DOWN,onStageMouseDown);
				  flagStageEvent = true;
			  }
			  this.mode = "editName";
			  this.input_name.visible = true;
			  this.input_name.text = txtName.text;
			  this.input_name.setFocus();
			  this.txtName.visible = false;
		  }
		  
	      //-------------------------------------------------------------------------
		  //end edit mode. if there is a changes, save them.
		  public function endEditMode(toSave:Boolean){
			  this.mouseChildren = false;
			  
			  if(this.mode == "normal") return(false);
			  switch(mode){
				  case "editName":
					this.mode = "normal";
				  	this.input_name.visible = false;
					this.txtName.visible = true;
					if(toSave == true && input_name.text != txtName.text){
						this.txtName.text = this.input_name.text;
						this.itemName = this.input_name.text;
						
						//call website to save the changes on server
						var website = this.parent.parent.parent;
						website.updateItem(this.itemID,txtName.text,this.itemDesc,this.itemLink);
					}
				  break;
			  }
		  }
		  
	      //-------------------------------------------------------------------------
		  //send request to website to delete single item
		  public function deleteSingleItemRequest(){
			  var website = this.parent.parent.parent;
			  website.showConfirmDialogStoreData("deleteSingleItem","Do you sure you want to delete \"" + this.itemName + "\""+"?",this.itemID);
		  }
		  
	      //-------------------------------------------------------------------------
		  //event on delete context menu click. send website 
		  public function onDeleteClick(event:ContextMenuEvent){
			  deleteSingleItemRequest();
		  }
		  
	      //-------------------------------------------------------------------------
		  // on preview item click.
		  public function onPreviewClick(event:ContextMenuEvent){
			  var movies_holder = this.parent;
			  movies_holder.previewItem(this.itemID);
		  }
		  
	      //-------------------------------------------------------------------------
		  // on download item click
		  public function onDownloadItemClick(event:ContextMenuEvent){
			  var website = this.parent.parent.parent;
			  website.downloadItemRequest(this.itemID,this.itemFilename);
		  }
		  
	      //-------------------------------------------------------------------------
		  //event on delete selected click.
		  public function onDeleteSelectedClick(event:ContextMenuEvent){
			  var editPanel = this.parent.parent;
			  editPanel.deleteSelectedStartOperation();
		  }
		  
	      //-------------------------------------------------------------------------
		  //event on click edit name menu item. switch to edit name mode.
		  public function onEditNameClick(event:ContextMenuEvent){
			  changeToEditMode(false);
		  }
		  
	      //-------------------------------------------------------------------------
		  //start editing description
		  public function startEditDesc(){
			  endEditMode(false);
			  var website = this.parent.parent.parent;
			  website.showItemEditDialog(this.itemID,this.itemName,this.itemDesc,this.itemLink);
		  }
		  
	      //-------------------------------------------------------------------------
		  //edit description click. open the item edit dialog
		  public function onEditDescriptionClick(event:ContextMenuEvent){
			  startEditDesc();
		  }
		  
	      //-------------------------------------------------------------------------
		  //return whether the item is selected or not.
		  public function isSelected(){
			  return(this.flagSelected);
		  }
		  
		   //-------------------------------------------------------------------------
		   // tell to the server that the items completed loading (whether if there was an error or not.)
 		  private function sendParentLoadComplete(){
			  dispatcher.dispatchEvent(new Event("itemLoadComplete"));
		  }
		  					  		  		  
		  //--------------------------------------------------
		  
		   private function loadProgress(event:ProgressEvent):void{			   
			 // trace("progress");
		   }

		  //--------------------------------------------------		  
		   // set item selected
		   public function setSelected(){
			   this.flagSelected = true;
			   mc_back_selected.visible = true;
			   mc_back.visible = false;
		   }
		   
		  //--------------------------------------------------		  
		  // set item normal
		   public function setNormal(){
			   this.flagSelected = false;
			   mc_back.visible = true;			   
			   mc_back_selected.visible = false;
		   }
		  
		  
		  //--------------------------------------------------
		  // set the item data like name, desc, order, type etc...
		  public function setData(obj){
			  this.itemID = obj.id;
			  this.itemName = obj.name;
			  this.itemLink = obj.link;
			  this.itemType = obj.itemType;
			  this.itemFilename = obj.filename;
			  this.itemDesc = obj.itemDesc;
			  this.itemOrder = obj.itemOrder;
			  this.txtName.text = itemName;
			  
			  this.contextItemMenuID.caption = "Item ID: " + this.itemID;
			  this.contextItemMenuID.visible = true;
			  
			  setUserPrevelege();
		  }
		  
		  //--------------------------------------------------
		  // set user type preveledge
		  public function setUserPrevelege(){
			  if(MainClass.userType == "user") this.contextItemMenuID.visible = false;
			  else this.contextItemMenuID.visible = true;	//admin
		  }
		  
		  //--------------------------------------------------
		  // loads the data by type.
		  public function loadItemData(){
			  var req:URLRequest = new URLRequest();
			  
			  switch(this.itemType){
				  case "image":
			  		  req.url = MainClass.urlActions;
					  req.method = "get";
					  var vars:URLVariables = new URLVariables();
					  vars.clientAction = "showimage";
					  vars.img = this.itemFilename;
					  vars.w = dataWidth;
					  vars.h = dataHeight;
					  req.data = vars;
				  break;
				  default:
				  	trace("wrong type");
					sendParentLoadComplete();
					return(false);
				  break;
			  }
			  this.mc_data.load(req);
		  }
		    
		  //--------------------------------------------------
		  
		   private function loadSecurityError(event:SecurityErrorEvent){
			   	this.holderState = "error";
				mc_preloader.visible = false;
				mc_loadError.visible = true;
				trace(event.text);
				sendParentLoadComplete();
		   }
			
			//-------------------------------------------------------------------------
	
			private function loadIOError(event:IOErrorEvent){
				this.holderState = "error";
				mc_preloader.visible = false;
				mc_loadError.visible = true;
				trace(event.text);
				sendParentLoadComplete();
			}
		  
		  
		  //--------------------------------------------------
		  // load item completed. position it to it's place. 
		  private function loadComplete(event:Event){
			  mc_preloader.visible = false;
			  this.holderState = "loaded";
			  this.addChild(mc_data);
			  var gap:Number;
			  
			  // place x
			  if(mc_data.width < this.dataWidth){
				  gap = Math.floor((this.dataWidth - mc_data.width)/2);
				  mc_data.x = this.datax + gap;
			  }
			  else mc_data.x = this.datax;

			  // place y  			  
			  if(mc_data.height < this.dataHeight){
				  gap = Math.floor((this.dataHeight - mc_data.height)/2);
				  mc_data.y = this.datay + gap;
			  }
			  else mc_data.y = this.datay;
			  
			  sendParentLoadComplete();
		  }
		  
		  //--------------------------------------------------
		  // add a border to movieclip
		  public function addBorderToSprite(mc:Sprite,width,height){			  
				var rect:Shape = new Shape; 
				rect.graphics.beginFill(0xF00FC4); //purple
				rect.graphics.drawRect(0,0,width+2,height+2);
				rect.graphics.endFill();
				rect.x=-1;
				rect.y=-1;
				mc.addChild(rect);
		  }
		  
		  //--------------------------------------------------
		  // duplicate mc_data according the type.
		  public function getDuplicatedData(){
			  var dup:Sprite = new Sprite();
			  if(this.holderState != "loaded"){
				  var mc_emptyClip = new EmptyClip();
				  mc_emptyClip.height = this.dataHeight;
				  mc_emptyClip.width = this.dataWidth;
				  mc_emptyClip.mouseEnabled = false;
				  addBorderToSprite(dup,mc_emptyClip.width,mc_emptyClip.height);
				  dup.mouseEnabled = false;
				  dup.addChild(mc_emptyClip);
				  return(dup);
			  }
				
			  switch(this.itemType){
				 case "image":
				 	var bdata:Bitmap = Bitmap(mc_data.content);
				 	var image_clone:Bitmap = new Bitmap(bdata.bitmapData.clone());
					addBorderToSprite(dup,image_clone.width,image_clone.height);
					dup.addChild(image_clone);
				 break;
				 default:
				 	trace("getDuplicatedData error - wrong type: " + this.itemType);
				 break;
			  }
			  return(dup);
		  }
		  
		  
		  //--------------------------------------------------
		  // set item name and description , and display name too.
		  public function setNameDesc(name:String,desc:String,link:String){
			  this.itemName = name;
			  this.itemDesc = desc;
			  this.itemLink = link;
			  this.txtName.text = name;
		  }
		  
	  }   
  }